<?php
/**
 * Initialize the custom theme options.
 */
add_action( 'admin_init', 'collars_custom_theme_options' );

/**
 * Build the custom settings & update OptionTree.
 */
function collars_custom_theme_options() {

	/* OptionTree is not loaded yet */
	if ( ! function_exists( 'ot_settings_id' ) )
		return false;

	/**
	 * Get a copy of the saved settings array.
	 */
	$saved_settings = get_option( ot_settings_id(), array() );

	/**
	 * Custom settings array that will eventually be
	 * passes to the OptionTree Settings API Class.
	 */
	$custom_settings = array(
		'contextual_help' => array(
			'sidebar'       => ''
		),
		'sections'        => array(
			array(
				'id'          => 'general',
				'title'       => __( 'General Options', 'tilt' )
			),
			array(
				'id'          => 'header_options',
				'title'       => __( 'Header', 'tilt' )
			),
			array(
				'id'          => 'title_options',
				'title'       => __( 'Title Area', 'tilt' )
			),
			array(
				'id'          => 'layouts_design',
				'title'       => __( 'Layouts &amp; Design', 'tilt' )
			),
			array(
				'id'          => 'color_typography',
				'title'       => __( 'Typography &amp; Colors', 'tilt' )
			),
			array(
				'id'          => 'custom_css',
				'title'       => __( 'Custom CSS', 'tilt' )
			),
			array(
				'id'          => 'import_data',
				'title'       => __( 'Import Demo', 'tilt' )
			),
			array(
				'id'          => 'import_successful',
				'title'       => __( 'Import Successful', 'tilt' )
			)
		),
		'settings'        => array(
			array(
				'id'          => 'primary_tab',
				'label'       => __( 'General', 'tilt' ),
				'desc'        => '',
				'std'         => '',
				'type'        => 'tab',
				'section'     => 'general',
				'rows'        => '',
				'post_type'   => '',
				'taxonomy'    => '',
				'min_max_step'=> '',
				'class'       => '',
				'condition'   => '',
				'operator'    => 'and'
			),
			array(
				'id'          => 'accent_color',
				'label'       => __( 'Theme accent color', 'tilt' ),
				'desc'        => __( 'This will be general color scheme for your website. Click input field for color picker.', 'tilt' ),
				'std'         => '#30b9e6',
				'type'        => 'colorpicker',
				'section'     => 'general',
				'rows'        => '',
				'post_type'   => '',
				'taxonomy'    => '',
				'min_max_step'=> '',
				'class'       => '',
				'condition'   => '',
				'operator'    => 'and'
			),
			array(
				'id'          => 'smooth_scroll',
				'label'       => __( 'Smooth page scroll', 'tilt' ),
				'desc'        => __( 'Add smooth page scrolling in Chrome browser.', 'tilt' ),
				'std'         => 'on',
				'type'        => 'on-off',
				'section'     => 'general',
				'rows'        => '',
				'post_type'   => '',
				'taxonomy'    => '',
				'min_max_step'=> '',
				'class'       => '',
				'condition'   => '',
				'operator'    => 'and'
			),
			array(
				'id'          => 'scroll_to_top_button',
				'label'       => __( 'Scroll to top button', 'tilt' ),
				'desc'        => __( 'Enable or disable "To Top" button when you scroll down.', 'tilt' ),
				'std'         => 'on',
				'type'        => 'on-off',
				'section'     => 'general',
				'rows'        => '',
				'post_type'   => '',
				'taxonomy'    => '',
				'min_max_step'=> '',
				'class'       => '',
				'condition'   => '',
				'operator'    => 'and'
			),
			array(
				'id'          => 'page_comments',
				'label'       => __( 'Comments on page', 'tilt' ),
				'desc'        => __( 'Turn ON or OFF comments on pages.', 'tilt' ),
				'std'         => 'off',
				'type'        => 'on-off',
				'section'     => 'general',
				'rows'        => '',
				'post_type'   => '',
				'taxonomy'    => '',
				'min_max_step'=> '',
				'class'       => '',
				'condition'   => '',
				'operator'    => 'and'
			),
			array(
				'id'          => 'favicon_tab',
				'label'       => __( 'Favicons', 'tilt' ),
				'desc'        => '',
				'std'         => '',
				'type'        => 'tab',
				'section'     => 'general',
				'rows'        => '',
				'post_type'   => '',
				'taxonomy'    => '',
				'min_max_step'=> '',
				'class'       => '',
				'condition'   => '',
				'operator'    => 'and'
			),
			array(
				'id'          => 'favicon',
				'label'       => __( 'Favicon', 'tilt' ),
				'desc'        => __( 'Size 16x16 px. Upload image in .ico format.', 'tilt' ),
				'std'         => '',
				'type'        => 'upload',
				'section'     => 'general',
				'rows'        => '',
				'post_type'   => '',
				'taxonomy'    => '',
				'min_max_step'=> '',
				'class'       => '',
				'condition'   => '',
				'operator'    => 'and'
			),
			array(
				'id'          => 'iphone_favicon',
				'label'       => __( 'iPhone icon', 'tilt' ),
				'desc'        => __( 'If set, anyone who saves your webpage to the home screen will see a nice app-like icon. <br />
Recommended image format is .png. <br />
Size 60x60 px.', 'tilt' ),
				'std'         => '',
				'type'        => 'upload',
				'section'     => 'general',
				'rows'        => '',
				'post_type'   => '',
				'taxonomy'    => '',
				'min_max_step'=> '',
				'class'       => '',
				'condition'   => '',
				'operator'    => 'and'
			),
			array(
				'id'          => 'iphone_favicon_retina',
				'label'       => __( 'iPhone retina icon', 'tilt' ),
				'desc'        => __( 'Size 120x120 px.', 'tilt' ),
				'std'         => '',
				'type'        => 'upload',
				'section'     => 'general',
				'rows'        => '',
				'post_type'   => '',
				'taxonomy'    => '',
				'min_max_step'=> '',
				'class'       => '',
				'condition'   => '',
				'operator'    => 'and'
			),
			array(
				'id'          => 'ipad_favicon',
				'label'       => __( 'iPad icon', 'tilt' ),
				'desc'        => __( 'Size 76x76 px.', 'tilt' ),
				'std'         => '',
				'type'        => 'upload',
				'section'     => 'general',
				'rows'        => '',
				'post_type'   => '',
				'taxonomy'    => '',
				'min_max_step'=> '',
				'class'       => '',
				'condition'   => '',
				'operator'    => 'and'
			),
			array(
				'id'          => 'ipad_favicon_retina',
				'label'       => __( 'iPad retina icon', 'tilt' ),
				'desc'        => __( 'Size 152x152 px.', 'tilt' ),
				'std'         => '',
				'type'        => 'upload',
				'section'     => 'general',
				'rows'        => '',
				'post_type'   => '',
				'taxonomy'    => '',
				'min_max_step'=> '',
				'class'       => '',
				'condition'   => '',
				'operator'    => 'and'
			),
			array(
				'id'          => 'code_tab',
				'label'       => __( 'Analytics &amp; Custom code', 'tilt' ),
				'desc'        => '',
				'std'         => '',
				'type'        => 'tab',
				'section'     => 'general',
				'rows'        => '',
				'post_type'   => '',
				'taxonomy'    => '',
				'min_max_step'=> '',
				'class'       => '',
				'condition'   => '',
				'operator'    => 'and'
			),
			array(
				'id'          => 'tracking_code',
				'label'       => __( 'Analytics / tracking code', 'tilt' ),
				'desc'        => __( 'Paste your Google Analytics or other tracking code in text area. Or any code to be placed before <code><span>&lt;</span>/head&gt;</code> in header file.', 'tilt' ),
				'std'         => '',
				'type'        => 'textarea-simple',
				'section'     => 'general',
				'rows'        => '10',
				'post_type'   => '',
				'taxonomy'    => '',
				'min_max_step'=> '',
				'class'       => '',
				'condition'   => '',
				'operator'    => 'and'
			),
			array(
				'id'          => 'code_after_body',
				'label'       => __( 'Code after <span>&lt;</span>body&gt;', 'tilt' ),
				'desc'        => __( 'Add your custom code right after <code><span>&lt;</span>body&gt;</code> tag. Can be useful for Facebook SDK.', 'tilt' ),
				'std'         => '',
				'type'        => 'textarea-simple',
				'section'     => 'general',
				'rows'        => '10',
				'post_type'   => '',
				'taxonomy'    => '',
				'min_max_step'=> '',
				'class'       => '',
				'condition'   => '',
				'operator'    => 'and'
			),
			array(
				'id'          => 'code_before_body',
				'label'       => __( 'Code before <span>&lt;</span>/body&gt;', 'tilt' ),
				'desc'        => __( 'Add your custom code in footer before <code><span>&lt;</span>/body&gt;</code> tag.', 'tilt' ),
				'std'         => '',
				'type'        => 'textarea-simple',
				'section'     => 'general',
				'rows'        => '10',
				'post_type'   => '',
				'taxonomy'    => '',
				'min_max_step'=> '',
				'class'       => '',
				'condition'   => '',
				'operator'    => 'and'
			),
			array(
				'id'          => 'oembed_tab',
				'label'       => __( 'oEmbed', 'tilt' ),
				'desc'        => '',
				'std'         => '',
				'type'        => 'tab',
				'section'     => 'general',
				'rows'        => '',
				'post_type'   => '',
				'taxonomy'    => '',
				'min_max_step'=> '',
				'class'       => '',
				'condition'   => '',
				'operator'    => 'and'
			),
			array(
				'id'          => 'twc_oembed_enable',
				'label'       => __( 'Allow others to embed content from this website', 'tilt' ),
				'std'         => 'on',
				'type'        => 'on-off',
				'section'     => 'general',
				'rows'        => '',
				'post_type'   => '',
				'taxonomy'    => '',
				'min_max_step'=> '',
				'class'       => '',
				'condition'   => '',
				'operator'    => 'and'
			),
			array(
				'id'          => 'twc_oembed_head',
				'label'       => __( 'Code before oEmbed', 'tilt' ),
				'desc'        => __( 'Your custom code or HTML before oEmbed when someone embeds content from your website.', 'tilt' ),
				'std'         => '',
				'type'        => 'textarea-simple',
				'section'     => 'general',
				'rows'        => '10',
				'post_type'   => '',
				'taxonomy'    => '',
				'min_max_step'=> '',
				'class'       => '',
				'condition'   => 'twc_oembed_enable:is(on)',
				'operator'    => 'and'
			),
			array(
				'id'          => 'twc_oembed_footer',
				'label'       => __( 'Code after oEmbed', 'tilt' ),
				'desc'        => __( 'Your custom code or HTML after oEmbed when someone embeds content from your website.', 'tilt' ),
				'std'         => '',
				'type'        => 'textarea-simple',
				'section'     => 'general',
				'rows'        => '10',
				'post_type'   => '',
				'taxonomy'    => '',
				'min_max_step'=> '',
				'class'       => '',
				'condition'   => 'twc_oembed_enable:is(on)',
				'operator'    => 'and'
			),
			array(
				'id'          => 'general_tab',
				'label'       => __( 'General', 'tilt' ),
				'desc'        => '',
				'std'         => '',
				'type'        => 'tab',
				'section'     => 'layouts_design',
				'rows'        => '',
				'post_type'   => '',
				'taxonomy'    => '',
				'min_max_step'=> '',
				'class'       => '',
				'condition'   => '',
				'operator'    => 'and'
			),
			array(
				'id'          => 'layout_style',
				'label'       => __( 'Layout style', 'tilt' ),
				'desc'        => __( '	1. Full width layout <br />
										2. Boxed layout', 'tilt' ),
				'std'         => 'full-width',
				'type'        => 'radio-image',
				'section'     => 'layouts_design',
				'rows'        => '',
				'post_type'   => '',
				'taxonomy'    => '',
				'min_max_step'=> '',
				'class'       => '',
				'condition'   => '',
				'operator'    => 'and'
			),
			array(
				'id'          => 'page_background',
				'label'       => __( 'Page background color', 'tilt' ),
				'desc'        => __( 'Choose page background for boxed layout.', 'tilt' ),
				'std'         => '#ffffff',
				'type'        => 'colorpicker',
				'section'     => 'layouts_design',
				'rows'        => '',
				'post_type'   => '',
				'taxonomy'    => '',
				'min_max_step'=> '',
				'class'       => '',
				'condition'   => 'layout_style:is(boxed)',
				'operator'    => 'and'
			),
			array(
				'id'          => 'body_background',
				'label'       => __( 'Body background', 'tilt' ),
				'desc'        => __( 'Choose body background for boxed layout.', 'tilt' ),
				'std'         => '',
				'type'        => 'background',
				'section'     => 'layouts_design',
				'rows'        => '',
				'post_type'   => '',
				'taxonomy'    => '',
				'min_max_step'=> '',
				'class'       => '',
				'condition'   => 'layout_style:is(boxed)',
				'operator'    => 'and'
			),
			array(
				'id'          => 'use_pattern',
				'label'       => __( 'Predefined pattern', 'tilt' ),
				'desc'        => __( 'Select background pattern for boxed layout.', 'tilt' ),
				'std'         => 'off',
				'type'        => 'on-off',
				'section'     => 'layouts_design',
				'rows'        => '',
				'post_type'   => '',
				'taxonomy'    => '',
				'min_max_step'=> '',
				'class'       => '',
				'condition'   => 'layout_style:is(boxed)',
				'operator'    => 'and'
			),
			array(
				'id'          => 'background_pattern',
				'label'       => __( 'Patterns', 'tilt' ),
				'desc'        => '',
				'std'         => '',
				'type'        => 'radio-image',
				'section'     => 'layouts_design',
				'rows'        => '',
				'post_type'   => '',
				'taxonomy'    => '',
				'min_max_step'=> '',
				'class'       => '',
				'condition'   => 'layout_style:is(boxed),use_pattern:is(on)',
				'operator'    => 'and'
			),
			array(
				'id'          => 'header_style',
				'label'       => __( 'Header width', 'tilt' ),
				'desc'        => __( 'For full width layout you can chose from 2 header styles:<br />
1. Full width<br />
2. Same as content width', 'tilt' ),
				'std'         => 'fixed-width',
				'type'        => 'radio-image',
				'section'     => 'layouts_design',
				'rows'        => '',
				'post_type'   => '',
				'taxonomy'    => '',
				'min_max_step'=> '',
				'class'       => '',
				'condition'   => 'layout_style:is(full-width)',
				'operator'    => 'and'
			),
			array(
				'id'          => 'content_width',
				'label'       => __( 'Content width', 'tilt' ),
				'desc'        => __( 'This setting will apply selected layout width to your website.', 'tilt' ),
				'std'         => '1200',
				'type'        => 'radio',
				'section'     => 'layouts_design',
				'rows'        => '',
				'post_type'   => '',
				'taxonomy'    => '',
				'min_max_step'=> '',
				'class'       => '',
				'condition'   => '',
				'operator'    => 'and',
				'choices'     => array(
					array(
						'value'       => '940',
						'label'       => __( '940px', 'tilt' ),
						'src'         => ''
					),
					array(
						'value'       => '1010',
						'label'       => __( '1010px', 'tilt' ),
						'src'         => ''
					),
					array(
						'value'       => '1120',
						'label'       => __( '1120px', 'tilt' ),
						'src'         => ''
					),
					array(
						'value'       => '1200',
						'label'       => __( '1200px', 'tilt' ),
						'src'         => ''
					)
				)
			),
			array(
				'id'          => 'blog_tab',
				'label'       => __( 'Blog', 'tilt' ),
				'desc'        => '',
				'std'         => '',
				'type'        => 'tab',
				'section'     => 'layouts_design',
				'rows'        => '',
				'post_type'   => '',
				'taxonomy'    => '',
				'min_max_step'=> '',
				'class'       => '',
				'condition'   => '',
				'operator'    => 'and'
			),
			array(
				'id'          => 'blog_layout',
				'label'       => __( 'Blog layout', 'tilt' ),
				'desc'        => __( '1. Full width content <br />
									2. Content / Right sidebar <br />
									3. Content / Left sidebar', 'tilt' ),
				'std'         => 'right-sidebar',
				'type'        => 'radio-image',
				'section'     => 'layouts_design',
				'rows'        => '',
				'post_type'   => '',
				'taxonomy'    => '',
				'min_max_step'=> '',
				'class'       => '',
				'condition'   => '',
				'operator'    => 'and'
			),
			array(
				'id'          => 'blog_template',
				'label'       => __( 'Blog template', 'tilt' ),
				'desc'        => __( '1. Tiled style <br />
									2. Clear style <br />
									3. Tilt branded style', 'tilt' ),
				'std'         => 'blog-clear',
				'type'        => 'radio-image',
				'section'     => 'layouts_design',
				'rows'        => '',
				'post_type'   => '',
				'taxonomy'    => '',
				'min_max_step'=> '',
				'class'       => '',
				'condition'   => '',
				'operator'    => 'and'
			),
			array(
				'id'          => 'content_type',
				'label'       => __( 'Content type for post preview', 'tilt' ),
				'desc'        => __( 'Choose what to display on blog index pages. Note that only \'Full Content\' respects WordPress \'read more\' tag.', 'tilt' ),
				'std'         => 'excerpt',
				'type'        => 'select',
				'section'     => 'layouts_design',
				'rows'        => '',
				'post_type'   => '',
				'taxonomy'    => '',
				'min_max_step'=> '',
				'class'       => '',
				'condition'   => '',
				'operator'    => 'and',
				'choices'     => array(
					array(
						'value'       => 'excerpt',
						'label'       => __( 'Excerpt', 'tilt' ),
						'src'         => ''
					),
					array(
						'value'       => 'full_content',
						'label'       => __( 'Full content', 'tilt' ),
						'src'         => ''
					)
				)
			),
			array(
				'id'          => 'exclude_from_blog',
				'label'       => __( 'Exclude category from blog', 'tilt' ),
				'desc'        => __( 'This option will exclude selected category posts from blog and search pages.', 'tilt' ),
				'std'         => '',
				'type'        => 'category-checkbox',
				'section'     => 'layouts_design',
				'rows'        => '',
				'post_type'   => '',
				'taxonomy'    => '',
				'min_max_step'=> '',
				'class'       => '',
				'condition'   => '',
				'operator'    => 'and'
			),
			array(
				'id'          => 'post_date',
				'label'       => __( 'Post date in meta', 'tilt' ),
				'desc'        => __( 'Do you want to display date in post meta fields?', 'tilt' ),
				'std'         => '',
				'type'        => 'on-off',
				'section'     => 'layouts_design',
				'rows'        => '',
				'post_type'   => '',
				'taxonomy'    => '',
				'min_max_step'=> '',
				'class'       => '',
				'condition'   => '',
				'operator'    => 'and'
			),
			array(
				'id'          => 'post_category',
				'label'       => __( 'Post category in meta', 'tilt' ),
				'desc'        => __( 'Do you want to display category in post meta fields?', 'tilt' ),
				'std'         => '',
				'type'        => 'on-off',
				'section'     => 'layouts_design',
				'rows'        => '',
				'post_type'   => '',
				'taxonomy'    => '',
				'min_max_step'=> '',
				'class'       => '',
				'condition'   => '',
				'operator'    => 'and'
			),
			array(
				'id'          => 'post_author',
				'label'       => __( 'Post author in meta', 'tilt' ),
				'desc'        => __( 'Do you want to display author in post meta fields?', 'tilt' ),
				'std'         => '',
				'type'        => 'on-off',
				'section'     => 'layouts_design',
				'rows'        => '',
				'post_type'   => '',
				'taxonomy'    => '',
				'min_max_step'=> '',
				'class'       => '',
				'condition'   => '',
				'operator'    => 'and'
			),
			array(
				'id'          => 'post_comments',
				'label'       => __( 'Comments link in meta', 'tilt' ),
				'desc'        => __( 'Do you want to display comment count in post meta fields?', 'tilt' ),
				'std'         => '',
				'type'        => 'on-off',
				'section'     => 'layouts_design',
				'rows'        => '',
				'post_type'   => '',
				'taxonomy'    => '',
				'min_max_step'=> '',
				'class'       => '',
				'condition'   => '',
				'operator'    => 'and'
			),
			array(
				'id'          => 'post_tab',
				'label'       => __( 'Posts', 'tilt' ),
				'desc'        => '',
				'std'         => '',
				'type'        => 'tab',
				'section'     => 'layouts_design',
				'rows'        => '',
				'post_type'   => '',
				'taxonomy'    => '',
				'min_max_step'=> '',
				'class'       => '',
				'condition'   => '',
				'operator'    => 'and'
			),
			array(
				'id'          => 'post_header',
				'label'       => __( 'Header menu style in posts', 'tilt' ),
				'desc'        => __( 'Choose the header style to display in all posts.', 'tilt' ),
				'std'         => 'header-blog',
				'type'        => 'radio',
				'section'     => 'layouts_design',
				'rows'        => '',
				'post_type'   => '',
				'taxonomy'    => '',
				'min_max_step'=> '',
				'class'       => '',
				'condition'   => '',
				'operator'    => 'and',
				'choices'     => array(
					array(
						'value'       => 'header-blog',
						'label'       => __( 'Blog header style', 'tilt' ),
						'src'         => ''
					),
					array(
						'value'       => 'header-default',
						'label'       => __( 'Default header style', 'tilt' ),
						'src'         => ''
					)
				)
			),
			array(
				'id'          => 'post_title',
				'label'       => __( 'Page title in posts', 'tilt' ),
				'desc'        => __( 'Display or hide page title in all posts?', 'tilt' ),
				'std'         => '',
				'type'        => 'on-off',
				'section'     => 'layouts_design',
				'rows'        => '',
				'post_type'   => '',
				'taxonomy'    => '',
				'min_max_step'=> '',
				'class'       => '',
				'condition'   => '',
				'operator'    => 'and'
			),
			array(
				'id'          => 'post_pre_content',
				'label'       => __( 'Custom pre-content area in posts', 'tilt' ),
				'desc'        => __( 'Display or hide custom pre-content area in all posts?', 'tilt' ),
				'std'         => '',
				'type'        => 'on-off',
				'section'     => 'layouts_design',
				'rows'        => '',
				'post_type'   => '',
				'taxonomy'    => '',
				'min_max_step'=> '',
				'class'       => '',
				'condition'   => '',
				'operator'    => 'and'
			),
			array(
				'id'          => 'post_layout',
				'label'       => __( 'Post layout', 'tilt' ),
				'desc'        => __( '	1. Full width content<br />
										2. Content / Right sidebar <br />
										3. Content / Left sidebar', 'tilt' ),
				'std'         => 'right-sidebar',
				'type'        => 'radio-image',
				'section'     => 'layouts_design',
				'rows'        => '',
				'post_type'   => '',
				'taxonomy'    => '',
				'min_max_step'=> '',
				'class'       => '',
				'condition'   => '',
				'operator'    => 'and'
			),
			array(
				'id'          => 'post_links',
				'label'       => __( 'Previous &amp; next post link', 'tilt' ),
				'desc'        => __( 'Do you want to display next and previous post links on single blog post page?', 'tilt' ),
				'std'         => '',
				'type'        => 'on-off',
				'section'     => 'layouts_design',
				'rows'        => '',
				'post_type'   => '',
				'taxonomy'    => '',
				'min_max_step'=> '',
				'class'       => '',
				'condition'   => '',
				'operator'    => 'and'
			),
			array(
				'id'          => 'post_tags',
				'label'       => __( 'Post tags after content', 'tilt' ),
				'desc'        => __( 'Display post tags on single post page?', 'tilt' ),
				'std'         => '',
				'type'        => 'on-off',
				'section'     => 'layouts_design',
				'rows'        => '',
				'post_type'   => '',
				'taxonomy'    => '',
				'min_max_step'=> '',
				'class'       => '',
				'condition'   => '',
				'operator'    => 'and'
			),
			array(
				'id'          => 'author_description',
				'label'       => __( 'Post author description', 'tilt' ),
				'desc'        => __( 'When ON, author info box will only appear for those post authors who have "Biographical Info" field filled!', 'tilt' ),
				'std'         => 'on',
				'type'        => 'on-off',
				'section'     => 'layouts_design',
				'rows'        => '',
				'post_type'   => '',
				'taxonomy'    => '',
				'min_max_step'=> '',
				'class'       => '',
				'condition'   => '',
				'operator'    => 'and'
			),
			array(
				'id'          => 'woocommerce_tab',
				'label'       => __( 'WooCommerce', 'tilt' ),
				'desc'        => '',
				'std'         => '',
				'type'        => 'tab',
				'section'     => 'layouts_design',
				'rows'        => '',
				'post_type'   => '',
				'taxonomy'    => '',
				'min_max_step'=> '',
				'class'       => '',
				'condition'   => '',
				'operator'    => 'and'
			),
			array(
				'id'          => 'cart_widget',
				'label'       => __( 'Display cart content on hover', 'tilt' ),
				'desc'        => __( 'Display cart content on icon hover (ON) or just lead to cart page on click (OFF)?', 'tilt' ),
				'std'         => 'on',
				'type'        => 'on-off',
				'section'     => 'layouts_design',
				'rows'        => '',
				'post_type'   => '',
				'taxonomy'    => '',
				'min_max_step'=> '',
				'class'       => '',
				'condition'   => 'cart_button:is(on)',
				'operator'    => 'and'
			),
			array(
				'id'          => 'catalog_layout',
				'label'       => __( 'Product archive page (shop) layout', 'tilt' ),
				'desc'        => __( '1. Full width content<br />
									2. Content / Right sidebar <br />
									3. Content / Left sidebar', 'tilt' ),
				'std'         => 'right-sidebar',
				'type'        => 'radio-image',
				'section'     => 'layouts_design',
				'rows'        => '',
				'post_type'   => '',
				'taxonomy'    => '',
				'min_max_step'=> '',
				'class'       => '',
				'condition'   => '',
				'operator'    => 'and'
			),
			array(
				'id'          => 'product_layout',
				'label'       => __( 'Single product page layout', 'tilt' ),
				'desc'        => __( '1. Full width content<br />
2. Content / Right sidebar <br />
3. Content / Left sidebar', 'tilt' ),
				'std'         => 'right-sidebar',
				'type'        => 'radio-image',
				'section'     => 'layouts_design',
				'rows'        => '',
				'post_type'   => '',
				'taxonomy'    => '',
				'min_max_step'=> '',
				'class'       => '',
				'condition'   => '',
				'operator'    => 'and'
			),
			array(
				'id'          => 'woo_columns',
				'label'       => __( 'Product column count', 'tilt' ),
				'desc'        => __( 'Choose column count for main product catalog page.', 'tilt' ),
				'std'         => '',
				'type'        => 'select',
				'section'     => 'layouts_design',
				'rows'        => '',
				'post_type'   => '',
				'taxonomy'    => '',
				'min_max_step'=> '',
				'class'       => '',
				'condition'   => '',
				'operator'    => 'and',
				'choices'     => array(
					array(
						'value'       => '3',
						'label'       => __( '3 columns', 'tilt' ),
						'src'         => ''
					),
					array(
						'value'       => '4',
						'label'       => __( '4 columns', 'tilt' ),
						'src'         => ''
					)
				)
			),
			array(
				'id'          => 'woo_product_count',
				'label'       => __( 'Products per page', 'tilt' ),
				'desc'        => __( 'Choose how many products to display on product catalog page.', 'tilt' ),
				'std'         => '9',
				'type'        => 'text',
				'section'     => 'layouts_design',
				'rows'        => '',
				'post_type'   => '',
				'taxonomy'    => '',
				'min_max_step'=> '',
				'class'       => '',
				'condition'   => '',
				'operator'    => 'and'
			),
			array(
				'id'          => 'search_tab',
				'label'       => __( 'Search', 'tilt' ),
				'desc'        => '',
				'std'         => '',
				'type'        => 'tab',
				'section'     => 'layouts_design',
				'rows'        => '',
				'post_type'   => '',
				'taxonomy'    => '',
				'min_max_step'=> '',
				'class'       => '',
				'condition'   => '',
				'operator'    => 'and'
			),
			array(
				'id'          => 'search_layout',
				'label'       => __( 'Search page layout', 'tilt' ),
				'desc'        => __( '	1. Full width content <br />
										2. Content / Right sidebar <br />
										3. Content / Left sidebar', 'tilt' ),
				'std'         => 'right-sidebar',
				'type'        => 'radio-image',
				'section'     => 'layouts_design',
				'rows'        => '',
				'post_type'   => '',
				'taxonomy'    => '',
				'min_max_step'=> '',
				'class'       => '',
				'condition'   => '',
				'operator'    => 'and'
			),
			array(
				'id'          => 'footer_copyright_tab',
				'label'       => __( 'Footer & Copyright', 'tilt' ),
				'desc'        => '',
				'std'         => '',
				'type'        => 'tab',
				'section'     => 'layouts_design',
				'rows'        => '',
				'post_type'   => '',
				'taxonomy'    => '',
				'min_max_step'=> '',
				'class'       => '',
				'condition'   => '',
				'operator'    => 'and'
			),
			array(
				'id'          => 'footer_layout',
				'label'       => __( 'Footer &amp; copyright layout', 'tilt' ),
				'desc'        => __( 'Choose between fixed and full width layouts.', 'tilt' ),
				'std'         => '',
				'type'        => 'select',
				'section'     => 'layouts_design',
				'rows'        => '',
				'post_type'   => '',
				'taxonomy'    => '',
				'min_max_step'=> '',
				'class'       => '',
				'condition'   => '',
				'operator'    => 'and',
				'choices'     => array(
					array(
						'value'       => '',
						'label'       => __( 'Fixed width', 'tilt' ),
						'src'         => ''
					),
					array(
						'value'       => 'row-inner-full',
						'label'       => __( 'Full width', 'tilt' ),
						'src'         => ''
					)
				)
			),
			array(
				'id'          => 'footer_columns',
				'label'       => __( 'Footer columns count', 'tilt' ),
				'desc'        => __( 'Choose the number of columns in footer.', 'tilt' ),
				'std'         => 'vc_col-sm-3',
				'type'        => 'select',
				'section'     => 'layouts_design',
				'rows'        => '',
				'post_type'   => '',
				'taxonomy'    => '',
				'min_max_step'=> '',
				'class'       => '',
				'condition'   => '',
				'operator'    => 'and',
				'choices'     => array(
					array(
						'value'       => 'vc_col-sm-12',
						'label'       => __( '1', 'tilt' ),
						'src'         => ''
					),
					array(
						'value'       => 'vc_col-sm-6',
						'label'       => __( '2', 'tilt' ),
						'src'         => ''
					),
					array(
						'value'       => 'vc_col-sm-4',
						'label'       => __( '3', 'tilt' ),
						'src'         => ''
					),
					array(
						'value'       => 'vc_col-sm-3',
						'label'       => __( '4', 'tilt' ),
						'src'         => ''
					)
				)
			),
			array(
				'id'          => 'footer_bg',
				'label'       => __( 'Footer background', 'tilt' ),
				'desc'        => __( 'You can either choose color or upload a background image. Leave blank for default setting.', 'tilt' ),
				'std'         => '',
				'type'        => 'background',
				'section'     => 'layouts_design',
				'rows'        => '',
				'post_type'   => '',
				'taxonomy'    => '',
				'min_max_step'=> '',
				'class'       => '',
				'condition'   => '',
				'operator'    => 'and'
			),
			array(
				'id'          => 'copyright_bg',
				'label'       => __( 'Copyright section background', 'tilt' ),
				'desc'        => __( 'You can either choose color or upload a background image. Leave blank for default setting.', 'tilt' ),
				'std'         => '',
				'type'        => 'background',
				'section'     => 'layouts_design',
				'rows'        => '',
				'post_type'   => '',
				'taxonomy'    => '',
				'min_max_step'=> '',
				'class'       => '',
				'condition'   => '',
				'operator'    => 'and'
			),
			array(
				'id'          => 'general_tab',
				'label'       => __( 'General', 'tilt' ),
				'desc'        => '',
				'std'         => '',
				'type'        => 'tab',
				'section'     => 'header_options',
				'rows'        => '',
				'post_type'   => '',
				'taxonomy'    => '',
				'min_max_step'=> '',
				'class'       => '',
				'condition'   => '',
				'operator'    => 'and'
			),
			array(
				'id'          => 'header_height',
				'label'       => __( 'Header height', 'tilt' ),
				'desc'        => __( 'Height of the header area (menu area). Example: <code>60px</code>', 'tilt' ),
				'std'         => '70px',
				'type'        => 'text',
				'section'     => 'header_options',
				'rows'        => '',
				'post_type'   => '',
				'taxonomy'    => '',
				'min_max_step'=> '',
				'class'       => '',
				'condition'   => '',
				'operator'    => 'and'
			),
			array(
				'id'          => 'menu_style',
				'label'       => __( 'Header menu style', 'tilt' ),
				'desc'        => __( 'Choose one of header styles.', 'tilt' ),
				'std'         => 'menu-light',
				'type'        => 'radio',
				'section'     => 'header_options',
				'rows'        => '',
				'post_type'   => '',
				'taxonomy'    => '',
				'min_max_step'=> '',
				'class'       => '',
				'condition'   => '',
				'operator'    => 'and',
				'choices'     => array(
					array(
						'value'       => 'menu-light',
						'label'       => __( 'Light style', 'tilt' ),
						'src'         => ''
					),
					array(
						'value'       => 'menu-dark',
						'label'       => __( 'Dark style', 'tilt' ),
						'src'         => ''
					)
				)
			),
			array(
				'id'          => 'menu_opacity',
				'label'       => __( 'Header opacity', 'tilt' ),
				'desc'        => __( 'Set background opacity for header. <br />0 = fully transparent and 100 = fully opaque.', 'tilt' ),
				'std'         => '100',
				'type'        => 'numeric-slider',
				'section'     => 'header_options',
				'rows'        => '',
				'post_type'   => '',
				'taxonomy'    => '',
				'min_max_step'=> '',
				'class'       => '',
				'condition'   => '',
				'operator'    => 'and'
			),
			array(
				'id'          => 'submenu_style',
				'label'       => __( 'Header submenu style', 'tilt' ),
				'desc'        => __( 'Choose one of header submenu styles.', 'tilt' ),
				'std'         => 'submenu-light',
				'type'        => 'radio',
				'section'     => 'header_options',
				'rows'        => '',
				'post_type'   => '',
				'taxonomy'    => '',
				'min_max_step'=> '',
				'class'       => '',
				'condition'   => '',
				'operator'    => 'and',
				'choices'     => array(
					array(
						'value'       => 'submenu-light',
						'label'       => __( 'Light style', 'tilt' ),
						'src'         => ''
					),
					array(
						'value'       => 'submenu-dark',
						'label'       => __( 'Dark style', 'tilt' ),
						'src'         => ''
					)
				)
			),
			array(
				'id'          => 'header_weight',
				'label'       => __( 'Header text weight', 'tilt' ),
				'desc'        => __( 'Affects weight and font-size of header navigation.', 'tilt' ),
				'std'         => 'header-bold',
				'type'        => 'radio',
				'section'     => 'header_options',
				'rows'        => '',
				'post_type'   => '',
				'taxonomy'    => '',
				'min_max_step'=> '',
				'class'       => '',
				'condition'   => '',
				'operator'    => 'and',
				'choices'     => array(
					array(
						'value'       => 'header-bold',
						'label'       => __( 'Bolder', 'tilt' ),
						'src'         => ''
					),
					array(
						'value'       => 'header-thin',
						'label'       => __( 'Lighter', 'tilt' ),
						'src'         => ''
					)
				)
			),
			array(
				'id'          => 'menu_font_size',
				'label'       => __( 'Menu font size', 'tilt' ),
				'desc'        => __( 'Choose the size of header menu tesxt. Example: <code>13px</code>', 'tilt' ),
				'std'         => '11px',
				'type'        => 'text',
				'section'     => 'header_options',
				'rows'        => '',
				'post_type'   => '',
				'taxonomy'    => '',
				'min_max_step'=> '',
				'class'       => '',
				'condition'   => '',
				'operator'    => 'and'
			),
			array(
				'id'          => 'menu_font',
				'label'       => __( 'Menu font', 'tilt' ),
				'desc'        => '',
				'std'         => '',
				'type'        => 'typography',
				'section'     => 'header_options',
				'rows'        => '',
				'post_type'   => '',
				'taxonomy'    => '',
				'min_max_step'=> '',
				'class'       => '',
				'condition'   => '',
				'operator'    => 'and'
			),
			array(
				'id'          => 'header_shadow',
				'label'       => __( 'Enable header shadow', 'tilt' ),
				'desc'        => __( 'Adds shadow to site header.', 'tilt' ),
				'std'         => 'off',
				'type'        => 'on-off',
				'section'     => 'header_options',
				'rows'        => '',
				'post_type'   => '',
				'taxonomy'    => '',
				'min_max_step'=> '',
				'class'       => '',
				'condition'   => '',
				'operator'    => 'and'
			),
			array(
				'id'          => 'search_button',
				'label'       => __( 'Search button in menu', 'tilt' ),
				'desc'        => __( 'Enables or disables search from menu.', 'tilt' ),
				'std'         => 'on',
				'type'        => 'on-off',
				'section'     => 'header_options',
				'rows'        => '',
				'post_type'   => '',
				'taxonomy'    => '',
				'min_max_step'=> '',
				'class'       => '',
				'condition'   => '',
				'operator'    => 'and'
			),
			array(
				'id'          => 'cart_button',
				'label'       => __( 'WooCommerce cart button in menu', 'tilt' ),
				'desc'        => __( 'Do you want a smart WooCommerce cart icon in main menu?', 'tilt' ),
				'std'         => 'on',
				'type'        => 'on-off',
				'section'     => 'header_options',
				'rows'        => '',
				'post_type'   => '',
				'taxonomy'    => '',
				'min_max_step'=> '',
				'class'       => '',
				'condition'   => '',
				'operator'    => 'and'
			),
			array(
				'id'          => 'logo_tab',
				'label'       => __( 'Logo', 'tilt' ),
				'desc'        => '',
				'std'         => '',
				'type'        => 'tab',
				'section'     => 'header_options',
				'rows'        => '',
				'post_type'   => '',
				'taxonomy'    => '',
				'min_max_step'=> '',
				'class'       => '',
				'condition'   => '',
				'operator'    => 'and'
			),
			array(
				'id'          => 'logo',
				'label'       => __( 'Logo', 'tilt' ),
				'desc'        => __( 'Please choose an image file for your logo.', 'tilt' ),
				'std'         => '',
				'type'        => 'upload',
				'section'     => 'header_options',
				'rows'        => '',
				'post_type'   => '',
				'taxonomy'    => '',
				'min_max_step'=> '',
				'class'       => '',
				'condition'   => '',
				'operator'    => 'and'
			),
			array(
				'id'          => 'logo_retina',
				'label'       => __( 'Logo (Retina version @2x)', 'tilt' ),
				'desc'        => __( 'Retina logo should be <code>2x</code> the size of default logo keeping the aspect ratio!', 'tilt' ),
				'std'         => '',
				'type'        => 'upload',
				'section'     => 'header_options',
				'rows'        => '',
				'post_type'   => '',
				'taxonomy'    => '',
				'min_max_step'=> '',
				'class'       => '',
				'condition'   => '',
				'operator'    => 'and'
			),
			array(
				'id'          => 'retina_logo_height',
				'label'       => __( 'Logo height', 'tilt' ),
				'desc'        => __( 'Please enter the logo height. This is required for the logo to be displayed properly. Remember to add <code>px</code> value in the end.<br />
Example: <code>100px</code>', 'tilt' ),
				'std'         => '',
				'type'        => 'text',
				'section'     => 'header_options',
				'rows'        => '',
				'post_type'   => '',
				'taxonomy'    => '',
				'min_max_step'=> '',
				'class'       => '',
				'condition'   => '',
				'operator'    => 'and'
			),
			array(
				'id'          => 'retina_logo_width',
				'label'       => __( 'Logo width', 'tilt' ),
				'desc'        => __( 'Please enter the logo width. This is required for the logo to be displayed properly. Remember to add <code>px</code> value in the end.<br />
Example: <code>100px</code>', 'tilt' ),
				'std'         => '',
				'type'        => 'text',
				'section'     => 'header_options',
				'rows'        => '',
				'post_type'   => '',
				'taxonomy'    => '',
				'min_max_step'=> '',
				'class'       => '',
				'condition'   => '',
				'operator'    => 'and'
			),
			array(
				'id'          => 'logo_top',
				'label'       => __( 'Margin top', 'tilt' ),
				'desc'        => __( 'Move your logo vertically with this option. Remember to add <code>px</code> value after the number. For example: <code>25px</code>', 'tilt' ),
				'std'         => '0px',
				'type'        => 'text',
				'section'     => 'header_options',
				'rows'        => '',
				'post_type'   => '',
				'taxonomy'    => '',
				'min_max_step'=> '',
				'class'       => '',
				'condition'   => '',
				'operator'    => 'and'
			),
			array(
				'id'          => 'logo_left',
				'label'       => __( 'Margin left', 'tilt' ),
				'desc'        => __( 'Move your logo horizontally with this option. Remember to add <code>px</code> value after the number. For example: <code>25px</code>', 'tilt' ),
				'std'         => '0px',
				'type'        => 'text',
				'section'     => 'header_options',
				'rows'        => '',
				'post_type'   => '',
				'taxonomy'    => '',
				'min_max_step'=> '',
				'class'       => '',
				'condition'   => '',
				'operator'    => 'and'
			),
			array(
				'id'          => 'stycky_header_tab',
				'label'       => __( 'Sticky header', 'tilt' ),
				'desc'        => '',
				'std'         => '',
				'type'        => 'tab',
				'section'     => 'header_options',
				'rows'        => '',
				'post_type'   => '',
				'taxonomy'    => '',
				'min_max_step'=> '',
				'class'       => '',
				'condition'   => '',
				'operator'    => 'and'
			),
			array(
				'id'          => 'sticky_header',
				'label'       => __( 'Sticky header', 'tilt' ),
				'desc'        => __( 'Do you want your header to stick to top while you scroll?', 'tilt' ),
				'std'         => 'on',
				'type'        => 'on-off',
				'section'     => 'header_options',
				'rows'        => '',
				'post_type'   => '',
				'taxonomy'    => '',
				'min_max_step'=> '',
				'class'       => '',
				'condition'   => '',
				'operator'    => 'and'
			),
			array(
				'id'          => 'sticky_header_height',
				'label'       => __( 'Sticky header height', 'tilt' ),
				'desc'        => __( 'Height of the header area when sticked to top. Example: <code>60px</code>', 'tilt' ),
				'std'         => '50px',
				'type'        => 'text',
				'section'     => 'header_options',
				'rows'        => '',
				'post_type'   => '',
				'taxonomy'    => '',
				'min_max_step'=> '',
				'class'       => '',
				'condition'   => 'sticky_header:is(on)',
				'operator'    => 'and'
			),
			array(
				'id'          => 'sticky_menu_style',
				'label'       => __( 'Sticky header menu style', 'tilt' ),
				'desc'        => __( 'Choose header style when sticked to top.', 'tilt' ),
				'std'         => 'sticked-light',
				'type'        => 'radio',
				'section'     => 'header_options',
				'rows'        => '',
				'post_type'   => '',
				'taxonomy'    => '',
				'min_max_step'=> '',
				'class'       => '',
				'condition'   => 'sticky_header:is(on)',
				'operator'    => 'and',
				'choices'     => array(
					array(
						'value'       => 'sticked-light',
						'label'       => __( 'Light style', 'tilt' ),
						'src'         => ''
					),
					array(
						'value'       => 'sticked-dark',
						'label'       => __( 'Dark style', 'tilt' ),
						'src'         => ''
					)
				)
			),
			array(
				'id'          => 'sticky_menu_opacity',
				'label'       => __( 'Sticky header opacity', 'tilt' ),
				'desc'        => __( 'Set background opacity for header sticked to top. <br />0 = fully transparent and 100 = fully opaque.', 'tilt' ),
				'std'         => '100',
				'type'        => 'numeric-slider',
				'section'     => 'header_options',
				'rows'        => '',
				'post_type'   => '',
				'taxonomy'    => '',
				'min_max_step'=> '',
				'class'       => '',
				'condition'   => 'sticky_header:is(on)',
				'operator'    => 'and'
			),
			array(
				'id'          => 'logo_sticked',
				'label'       => __( 'Logo when header sticked', 'tilt' ),
				'desc'        => __( 'You can choose a different logo to display when a header is sticked to the top.', 'tilt' ),
				'std'         => '',
				'type'        => 'upload',
				'section'     => 'header_options',
				'rows'        => '',
				'post_type'   => '',
				'taxonomy'    => '',
				'min_max_step'=> '',
				'class'       => '',
				'condition'   => 'sticky_header:is(on)',
				'operator'    => 'and'
			),
			array(
				'id'          => 'logo_retina_sticked',
				'label'       => __( 'Logo when header sticked (Retina version @2x)', 'tilt' ),
				'desc'        => __( 'You can choose a different logo to display when a header is sticked to the top. <br/>
										Retina logo should be <code>2x</code> the size of default logo keeping the aspect ratio!', 'tilt' ),
				'std'         => '',
				'type'        => 'upload',
				'section'     => 'header_options',
				'rows'        => '',
				'post_type'   => '',
				'taxonomy'    => '',
				'min_max_step'=> '',
				'class'       => '',
				'condition'   => 'sticky_header:is(on)',
				'operator'    => 'and'
			),
			array(
				'id'          => 'retina_logo_height_sticked',
				'label'       => __( 'Logo height in sticky header', 'tilt' ),
				'desc'        => __( 'Please enter the logo height in sticky header. This is required for the logo to be displayed properly. Remember to add <code>px</code> value in the end.<br />
Example: <code>100px</code>', 'tilt' ),
				'std'         => '',
				'type'        => 'text',
				'section'     => 'header_options',
				'rows'        => '',
				'post_type'   => '',
				'taxonomy'    => '',
				'min_max_step'=> '',
				'class'       => '',
				'condition'   => '',
				'operator'    => 'and'
			),
			array(
				'id'          => 'retina_logo_width_sticked',
				'label'       => __( 'Logo width in sticky header', 'tilt' ),
				'desc'        => __( 'Please enter the logo width in sticky header. This is required for the logo to be displayed properly. Remember to add <code>px</code> value in the end.<br />
Example: <code>100px</code>', 'tilt' ),
				'std'         => '',
				'type'        => 'text',
				'section'     => 'header_options',
				'rows'        => '',
				'post_type'   => '',
				'taxonomy'    => '',
				'min_max_step'=> '',
				'class'       => '',
				'condition'   => '',
				'operator'    => 'and'
			),
			array(
				'id'          => 'logo_top_sticked',
				'label'       => __( 'Margin top', 'tilt' ),
				'desc'        => __( 'Move your logo vertically with this option. Remember to add <code>px</code> value after the number. For example: <code>25px</code>', 'tilt' ),
				'std'         => '0px',
				'type'        => 'text',
				'section'     => 'header_options',
				'rows'        => '',
				'post_type'   => '',
				'taxonomy'    => '',
				'min_max_step'=> '',
				'class'       => '',
				'condition'   => '',
				'operator'    => 'and'
			),
			array(
				'id'          => 'logo_left_sticked',
				'label'       => __( 'Margin left', 'tilt' ),
				'desc'        => __( 'Move your logo horizontally with this option. Remember to add <code>px</code> value after the number. For example: <code>25px</code>', 'tilt' ),
				'std'         => '0px',
				'type'        => 'text',
				'section'     => 'header_options',
				'rows'        => '',
				'post_type'   => '',
				'taxonomy'    => '',
				'min_max_step'=> '',
				'class'       => '',
				'condition'   => '',
				'operator'    => 'and'
			),
			array(
				'id'          => 'menu_tab',
				'label'       => __( 'Menu', 'tilt' ),
				'desc'        => '',
				'std'         => '',
				'type'        => 'tab',
				'section'     => 'header_options',
				'rows'        => '',
				'post_type'   => '',
				'taxonomy'    => '',
				'min_max_step'=> '',
				'class'       => '',
				'condition'   => '',
				'operator'    => 'and'
			),
			array(
				'id'          => 'show_menu_styles',
				'label'       => __( 'Enable menu styles', 'tilt' ),
				'desc'        => __( 'Will override header styles for menu section.', 'tilt' ),
				'std'         => 'off',
				'type'        => 'on-off',
				'section'     => 'header_options',
				'rows'        => '',
				'post_type'   => '',
				'taxonomy'    => '',
				'min_max_step'=> '',
				'class'       => '',
				'condition'   => '',
				'operator'    => 'and'
			),
			array(
				'id'          => 'header_bg',
				'label'       => __( 'Header background color', 'tilt' ),
				'desc'        => __( 'Choose your site header color.', 'tilt' ),
				'std'         => '',
				'type'        => 'colorpicker',
				'section'     => 'header_options',
				'rows'        => '',
				'post_type'   => '',
				'taxonomy'    => '',
				'min_max_step'=> '',
				'class'       => '',
				'condition'   => 'show_menu_styles:is(on)',
				'operator'    => 'and'
			),
			array(
				'id'          => 'default_menu_link',
				'label'       => __( 'Menu link color', 'tilt' ),
				'desc'        => __( 'Click input field for color picker or enter your custom value.', 'tilt' ),
				'std'         => '',
				'type'        => 'colorpicker',
				'section'     => 'header_options',
				'rows'        => '',
				'post_type'   => '',
				'taxonomy'    => '',
				'min_max_step'=> '',
				'class'       => '',
				'condition'   => 'show_menu_styles:is(on)',
				'operator'    => 'and'
			),
			array(
				'id'          => 'default_menu_link_h',
				'label'       => __( 'Menu link hover color', 'tilt' ),
				'desc'        => __( 'Leave empty to use "Theme accent color".', 'tilt' ),
				'std'         => '',
				'type'        => 'colorpicker',
				'section'     => 'header_options',
				'rows'        => '',
				'post_type'   => '',
				'taxonomy'    => '',
				'min_max_step'=> '',
				'class'       => '',
				'condition'   => 'show_menu_styles:is(on)',
				'operator'    => 'and'
			),
			array(
				'id'          => 'menu_hover_bg',
				'label'       => __( 'Menu item background hover color', 'tilt' ),
				'desc'        => __( 'Background color for hovered menu item. <br />
									Leave empty for: <br/>
									 - transparent background for top menu <br/>
									 - transparent black cover with 6% opacity for submenu items', 'tilt' ),
				'std'         => '',
				'type'        => 'colorpicker',
				'section'     => 'header_options',
				'rows'        => '',
				'post_type'   => '',
				'taxonomy'    => '',
				'min_max_step'=> '',
				'class'       => '',
				'condition'   => 'show_menu_styles:is(on)',
				'operator'    => 'and'
			),
			array(
				'id'          => 'menu_bottom_border',
				'label'       => __( 'Menu bottom border', 'tilt' ),
				'desc'        => __( 'Sets 1px bottom border for menu. <br />
Leave empty for no border.', 'tilt' ),
				'std'         => '',
				'type'        => 'colorpicker',
				'section'     => 'header_options',
				'rows'        => '',
				'post_type'   => '',
				'taxonomy'    => '',
				'min_max_step'=> '',
				'class'       => '',
				'condition'   => 'show_menu_styles:is(on)',
				'operator'    => 'and'
			),
			array(
				'id'          => 'submenu_tab',
				'label'       => __( 'Submenu', 'tilt' ),
				'desc'        => '',
				'std'         => '',
				'type'        => 'tab',
				'section'     => 'header_options',
				'rows'        => '',
				'post_type'   => '',
				'taxonomy'    => '',
				'min_max_step'=> '',
				'class'       => '',
				'condition'   => '',
				'operator'    => 'and'
			),
			array(
				'id'          => 'show_submenu_styles',
				'label'       => __( 'Enable submenu styles', 'tilt' ),
				'desc'        => __( 'Will override general menu styles for submenu section.', 'tilt' ),
				'std'         => 'off',
				'type'        => 'on-off',
				'section'     => 'header_options',
				'rows'        => '',
				'post_type'   => '',
				'taxonomy'    => '',
				'min_max_step'=> '',
				'class'       => '',
				'condition'   => '',
				'operator'    => 'and'
			),
			array(
				'id'          => 'submenu_background',
				'label'       => __( 'Submenu background color', 'tilt' ),
				'desc'        => __( 'Background color for the submenu section. <br />
Leave empty for same color as header.', 'tilt' ),
				'std'         => '',
				'type'        => 'colorpicker',
				'section'     => 'header_options',
				'rows'        => '',
				'post_type'   => '',
				'taxonomy'    => '',
				'min_max_step'=> '',
				'class'       => '',
				'condition'   => 'show_submenu_styles:is(on)',
				'operator'    => 'and'
			),
			array(
				'id'          => 'submenu_link_color',
				'label'       => __( 'Submenu link color', 'tilt' ),
				'desc'        => __( 'Color for links in submenu. Leave empty for main menu link color.', 'tilt' ),
				'std'         => '',
				'type'        => 'colorpicker',
				'section'     => 'header_options',
				'rows'        => '',
				'post_type'   => '',
				'taxonomy'    => '',
				'min_max_step'=> '',
				'class'       => '',
				'condition'   => 'show_submenu_styles:is(on)',
				'operator'    => 'and'
			),
			array(
				'id'          => 'submenu_link_hover_color',
				'label'       => __( 'Submenu link hover color', 'tilt' ),
				'desc'        => __( 'Hover color for links in submenu. Leave empty for main menu link color.', 'tilt' ),
				'std'         => '',
				'type'        => 'colorpicker',
				'section'     => 'header_options',
				'rows'        => '',
				'post_type'   => '',
				'taxonomy'    => '',
				'min_max_step'=> '',
				'class'       => '',
				'condition'   => 'show_submenu_styles:is(on)',
				'operator'    => 'and'
			),
			array(
				'id'          => 'submenu_hover_bg',
				'label'       => __( 'Submenu item background hover color', 'tilt' ),
				'desc'        => __( 'Background color for hovered menu item. <br />
									Leave empty for transparent black cover with 6% opacity.', 'tilt' ),
				'std'         => '',
				'type'        => 'colorpicker',
				'section'     => 'header_options',
				'rows'        => '',
				'post_type'   => '',
				'taxonomy'    => '',
				'min_max_step'=> '',
				'class'       => '',
				'condition'   => 'show_submenu_styles:is(on)',
				'operator'    => 'and'
			),
			array(
				'id'          => 'megamenu_separator_color',
				'label'       => __( 'Megamenu column separator color', 'tilt' ),
				'desc'        => __( 'Leave empty for default color.', 'tilt' ),
				'std'         => '',
				'type'        => 'colorpicker',
				'section'     => 'header_options',
				'rows'        => '',
				'post_type'   => '',
				'taxonomy'    => '',
				'min_max_step'=> '',
				'class'       => '',
				'condition'   => 'show_submenu_styles:is(on)',
				'operator'    => 'and'
			),
			array(
				'id'          => 'anim_tab',
				'label'       => __( 'Animation', 'tilt' ),
				'desc'        => '',
				'std'         => '',
				'type'        => 'tab',
				'section'     => 'header_options',
				'rows'        => '',
				'post_type'   => '',
				'taxonomy'    => '',
				'min_max_step'=> '',
				'class'       => '',
				'condition'   => '',
				'operator'    => 'and'
			),
			array(
				'id'          => 'menu_anim_enable',
				'label'       => __( 'Enable submenu animation?', 'tilt' ),
				'desc'        => __( 'Enables header submenu animation on link hover.', 'tilt' ),
				'std'         => 'on',
				'type'        => 'on-off',
				'section'     => 'header_options',
				'rows'        => '',
				'post_type'   => '',
				'taxonomy'    => '',
				'min_max_step'=> '',
				'class'       => '',
				'condition'   => '',
				'operator'    => 'and'
			),
			array(
				'id'          => 'animation_type',
				'label'       => __( 'Animation type', 'tilt' ),
				'desc'        => __( 'Choose the type of animation for submenu.', 'tilt' ),
				'std'         => 'from-top',
				'type'        => 'radio',
				'section'     => 'header_options',
				'rows'        => '',
				'post_type'   => '',
				'taxonomy'    => '',
				'min_max_step'=> '',
				'class'       => '',
				'condition'   => 'menu_anim_enable:is(on)',
				'operator'    => 'and',
				'choices'     => array(
					array(
						'value'       => 'fade-in',
						'label'       => __( 'Fade in', 'tilt' ),
						'src'         => ''
					),
					array(
						'value'       => 'from-top',
						'label'       => __( 'Fly in from top', 'tilt' ),
						'src'         => ''
					),
					array(
						'value'       => 'from-bottom',
						'label'       => __( 'Fly in from bottom', 'tilt' ),
						'src'         => ''
					),
					array(
						'value'       => 'scale',
						'label'       => __( 'Scale up', 'tilt' ),
						'src'         => ''
					),
					array(
						'value'       => 'slide',
						'label'       => __( 'Slide down', 'tilt' ),
						'src'         => ''
					)
				)
			),
			array(
				'id'          => 'anim_duration',
				'label'       => __( 'Animation duration', 'tilt' ),
				'desc'        => __( 'Choose the speed in <code>ms</code> of submenu appearance animation. <br/>
									Default value is <code>300ms</code>', 'tilt' ),
				'std'         => '300',
				'type'        => 'numeric_slider',
				'section'     => 'header_options',
				'rows'        => '',
				'post_type'   => '',
				'taxonomy'    => '',
				'min_max_step'=> '100,1000,100',
				'class'       => '',
				'condition'   => 'menu_anim_enable:is(on)',
				'operator'    => 'and'
			),
			array(
				'id'          => 'top_bar_tab',
				'label'       => __( 'Top bar', 'tilt' ),
				'desc'        => '',
				'std'         => '',
				'type'        => 'tab',
				'section'     => 'header_options',
				'rows'        => '',
				'post_type'   => '',
				'taxonomy'    => '',
				'min_max_step'=> '',
				'class'       => '',
				'condition'   => '',
				'operator'    => 'and'
			),
			array(
				'id'          => 'top_bar',
				'label'       => __( 'Header top bar', 'tilt' ),
				'desc'        => __( 'Top bar appears in header above the menu. If activated, new widget areas appear in Appearance/Widgets - \'Top Bar Sidebar Left\' and \'Top Bar Sidebar Right\'.', 'tilt' ),
				'std'         => 'off',
				'type'        => 'on-off',
				'section'     => 'header_options',
				'rows'        => '',
				'post_type'   => '',
				'taxonomy'    => '',
				'min_max_step'=> '',
				'class'       => '',
				'condition'   => '',
				'operator'    => 'and'

			),
			array(
				'id'          => 'top_bar_bg',
				'label'       => __( 'Background color', 'tilt' ),
				'desc'        => __( 'Click input field for color picker or enter your custom value.', 'tilt' ),
				'std'         => '#2c3e50',
				'type'        => 'colorpicker',
				'section'     => 'header_options',
				'rows'        => '',
				'post_type'   => '',
				'taxonomy'    => '',
				'min_max_step'=> '',
				'class'       => '',
				'condition'   => 'top_bar:is(on)',
				'operator'    => 'and'
			),
			array(
				'id'          => 'top_bar_text_color',
				'label'       => __( 'Text and link color', 'tilt' ),
				'desc'        => __( 'Click input field for color picker or enter your custom value.', 'tilt' ),
				'std'         => '#ffffff',
				'type'        => 'colorpicker',
				'section'     => 'header_options',
				'rows'        => '',
				'post_type'   => '',
				'taxonomy'    => '',
				'min_max_step'=> '',
				'class'       => '',
				'condition'   => 'top_bar:is(on)',
				'operator'    => 'and'
			),
			array(
				'id'          => 'top_bar_link_hover',
				'label'       => __( 'Link hover color', 'tilt' ),
				'desc'        => __( 'Click input field for color picker or enter your custom value.', 'tilt' ),
				'std'         => '',
				'type'        => 'colorpicker',
				'section'     => 'header_options',
				'rows'        => '',
				'post_type'   => '',
				'taxonomy'    => '',
				'min_max_step'=> '',
				'class'       => '',
				'condition'   => 'top_bar:is(on)',
				'operator'    => 'and'
			),
			array(
				'id'          => 'mmenu_tab',
				'label'       => __( 'Mobile menu', 'tilt' ),
				'desc'        => '',
				'std'         => '',
				'type'        => 'tab',
				'section'     => 'header_options',
				'rows'        => '',
				'post_type'   => '',
				'taxonomy'    => '',
				'min_max_step'=> '',
				'class'       => '',
				'condition'   => '',
				'operator'    => 'and'
			),
			array(
				'id'          => 'switch_to_mobile',
				'label'       => __( 'Mobile menu breakpoint', 'tilt' ),
				'desc'        => __( 'Set viewport width at which menu should switch to mobile version. <br /> Remember to add <code>px</code> value after the number.', 'tilt' ),
				'std'         => '768px',
				'type'        => 'text',
				'section'     => 'header_options',
				'rows'        => '',
				'post_type'   => '',
				'taxonomy'    => '',
				'min_max_step'=> '',
				'class'       => '',
				'condition'   => '',
				'operator'    => 'and'
			),
			array(
				'id'          => 'mmenu_header',
				'label'       => __( 'Mobile menu header background color', 'tilt' ),
				'desc'        => __( 'Choose background color for menu header in mobile view.', 'tilt' ),
				'std'         => '',
				'type'        => 'colorpicker',
				'section'     => 'header_options',
				'rows'        => '',
				'post_type'   => '',
				'taxonomy'    => '',
				'min_max_step'=> '',
				'class'       => '',
				'condition'   => '',
				'operator'    => 'and'
			),
			array(
				'id'          => 'mmenu_bg',
				'label'       => __( 'Mobile menu background color', 'tilt' ),
				'desc'        => __( 'Choose background color for menu in mobile view.', 'tilt' ),
				'std'         => '',
				'type'        => 'colorpicker',
				'section'     => 'header_options',
				'rows'        => '',
				'post_type'   => '',
				'taxonomy'    => '',
				'min_max_step'=> '',
				'class'       => '',
				'condition'   => '',
				'operator'    => 'and'
			),
			array(
				'id'          => 'mmenu_color',
				'label'       => __( 'Mobile menu text &amp icons color', 'tilt' ),
				'desc'        => __( 'Choose background color for menu in mobile view.', 'tilt' ),
				'std'         => '',
				'type'        => 'colorpicker',
				'section'     => 'header_options',
				'rows'        => '',
				'post_type'   => '',
				'taxonomy'    => '',
				'min_max_step'=> '',
				'class'       => '',
				'condition'   => '',
				'operator'    => 'and'
			),
			array(
				'id'          => 'title_content_tab',
				'label'       => __( 'Content Design', 'tilt' ),
				'desc'        => '',
				'std'         => '',
				'type'        => 'tab',
				'section'     => 'title_options',
				'rows'        => '',
				'post_type'   => '',
				'taxonomy'    => '',
				'min_max_step'=> '',
				'class'       => '',
				'condition'   => '',
				'operator'    => 'and'
			),
			array(
				'id'          => 'title_color',
				'label'       => __( 'Title color', 'tilt' ),
				'desc'        => __( 'Pick a preferrable color for page title.', 'tilt' ),
				'std'         => '#36353c',
				'type'        => 'colorpicker',
				'section'     => 'title_options',
				'rows'        => '',
				'post_type'   => '',
				'taxonomy'    => '',
				'min_max_step'=> '',
				'class'       => '',
				'condition'   => '',
				'operator'    => 'and'
			),
			array(
				'id'          => 'title_text_size',
				'label'       => __( 'Page title font size', 'tilt' ),
				'desc'        => __( 'Set the size of the page title. <br /> Remember to add <code>px</code> value after the number.', 'tilt' ),
				'std'         => '40px',
				'type'        => 'text',
				'section'     => 'title_options',
				'rows'        => '',
				'post_type'   => '',
				'taxonomy'    => '',
				'min_max_step'=> '',
				'class'       => '',
				'condition'   => '',
				'operator'    => 'and'
			),
			array(
				'id'          => 'title_font',
				'label'       => __( 'Page title font', 'tilt' ),
				'desc'        => '',
				'std'         => '',
				'type'        => 'typography',
				'section'     => 'title_options',
				'rows'        => '',
				'post_type'   => '',
				'taxonomy'    => '',
				'min_max_step'=> '',
				'class'       => '',
				'condition'   => '',
				'operator'    => 'and'
			),
			array(
				'id'          => 'title_alignment',
				'label'       => __( 'Title and breadcrumbs alignment', 'tilt' ),
				'desc'        => __( 'Choose one of three options for title and breadcrumbs alignment.', 'tilt' ),
				'std'         => 'tc-bc',
				'type'        => 'radio',
				'section'     => 'title_options',
				'rows'        => '',
				'post_type'   => '',
				'taxonomy'    => '',
				'min_max_step'=> '',
				'class'       => '',
				'condition'   => '',
				'operator'    => 'and',
				'choices'     => array(
					array(
						'value'       => 'tc-bc',
						'label'       => __( 'Title and breadcrumbs centered', 'tilt' ),
						'src'         => ''
					),
					array(
						'value'       => 'tl-bl',
						'label'       => __( 'Title and breadcrumbs aligned left', 'tilt' ),
						'src'         => ''
					),
					array(
						'value'       => 'tl-br',
						'label'       => __( 'Title aligned left, breadcrumbs aligned right', 'tilt' ),
						'src'         => ''
					),
					array(
						'value'       => 'tr-br',
						'label'       => __( 'Title and breadcrumbs aligned right', 'tilt' ),
						'src'         => ''
					),
					array(
						'value'       => 'tr-bl',
						'label'       => __( 'Title aligned right, breadcrumbs aligned left', 'tilt' ),
						'src'         => ''
					)
				)
			),
			array(
				'id'          => 'title_decor_tab',
				'label'       => __( 'Decoration', 'tilt' ),
				'desc'        => '',
				'std'         => '',
				'type'        => 'tab',
				'section'     => 'title_options',
				'rows'        => '',
				'post_type'   => '',
				'taxonomy'    => '',
				'min_max_step'=> '',
				'class'       => '',
				'condition'   => '',
				'operator'    => 'and'
			),
			array(
				'id'          => 'title_bg',
				'label'       => __( 'Background', 'tilt' ),
				'desc'        => __( 'You can either use color or upload a background image. Leave blank for transparent background.', 'tilt' ),
				'std'         => '',
				'type'        => 'background',
				'section'     => 'title_options',
				'rows'        => '',
				'post_type'   => '',
				'taxonomy'    => '',
				'min_max_step'=> '',
				'class'       => '',
				'condition'   => '',
				'operator'    => 'and'
			),
			array(
				'id'          => 'title_padding_top',
				'label'       => __( 'Top padding', 'tilt' ),
				'desc'        => __( 'Enter the preferrable top padding of your page title area. <br />
									Remember to add <code>px</code> value after the number. For example: <code>30px</code>', 'tilt' ),
				'std'         => '60px',
				'type'        => 'text',
				'section'     => 'title_options',
				'rows'        => '',
				'post_type'   => '',
				'taxonomy'    => '',
				'min_max_step'=> '',
				'class'       => '',
				'condition'   => '',
				'operator'    => 'and'
			),
			array(
				'id'          => 'title_padding_bottom',
				'label'       => __( 'Bottom padding', 'tilt' ),
				'desc'        => __( 'Enter the preferrable bottom padding of your page title area. <br />
									Remember to add <code>px</code> value after the number. For example: <code>30px</code>', 'tilt' ),
				'std'         => '60px',
				'type'        => 'text',
				'section'     => 'title_options',
				'rows'        => '',
				'post_type'   => '',
				'taxonomy'    => '',
				'min_max_step'=> '',
				'class'       => '',
				'condition'   => '',
				'operator'    => 'and'
			),
			array(
				'id'          => 'breadcrumbs_tab',
				'label'       => __( 'Breadcrumbs', 'tilt' ),
				'desc'        => '',
				'std'         => '',
				'type'        => 'tab',
				'section'     => 'title_options',
				'rows'        => '',
				'post_type'   => '',
				'taxonomy'    => '',
				'min_max_step'=> '',
				'class'       => '',
				'condition'   => '',
				'operator'    => 'and'
			),
			array(
				'id'          => 'breadcrumb',
				'label'       => __( 'Breadcrumbs', 'tilt' ),
				'desc'        => __( 'Enable or disable breadcrumbs under the page or post title.', 'tilt' ),
				'std'         => 'on',
				'type'        => 'on-off',
				'section'     => 'title_options',
				'rows'        => '',
				'post_type'   => '',
				'taxonomy'    => '',
				'min_max_step'=> '',
				'class'       => '',
				'condition'   => '',
				'operator'    => 'and'
			),
			array(
				'id'          => 'breadcrumbs_divider',
				'label'       => __( 'Breadcrumbs divider', 'tilt' ),
				'desc'        => __( 'Enter divider symbol or leave empty to use the default symbol <code>/</code>.', 'tilt' ),
				'std'         => '',
				'type'        => 'text',
				'section'     => 'title_options',
				'rows'        => '',
				'post_type'   => '',
				'taxonomy'    => '',
				'min_max_step'=> '',
				'class'       => '',
				'condition'   => 'breadcrumb:is(on)',
				'operator'    => 'and'
			),
			array(
				'id'          => 'breadcrumbs_color',
				'label'       => __( 'Breadcrumb color', 'tilt' ),
				'desc'        => __( 'Click input field for color picker or enter your custom value.', 'tilt' ),
				'std'         => '#36353c',
				'type'        => 'colorpicker',
				'section'     => 'title_options',
				'rows'        => '',
				'post_type'   => '',
				'taxonomy'    => '',
				'min_max_step'=> '',
				'class'       => '',
				'condition'   => 'breadcrumb:is(on)',
				'operator'    => 'and'
			),
			array(
				'id'          => 'breadcrumbs_color_link',
				'label'       => __( 'Breadcrumb link color', 'tilt' ),
				'desc'        => __( 'Click input field for color picker or enter your custom value. If left empty, general breadcrumbs color will be used.', 'tilt' ),
				'std'         => '',
				'type'        => 'colorpicker',
				'section'     => 'title_options',
				'rows'        => '',
				'post_type'   => '',
				'taxonomy'    => '',
				'min_max_step'=> '',
				'class'       => '',
				'condition'   => 'breadcrumb:is(on)',
				'operator'    => 'and'
			),
			array(
				'id'          => 'breadcrumbs_hover_color',
				'label'       => __( 'Breadcrumb hover color', 'tilt' ),
				'desc'        => __( 'Click input field for color picker or enter your custom value.', 'tilt' ),
				'std'         => '',
				'type'        => 'colorpicker',
				'section'     => 'title_options',
				'rows'        => '',
				'post_type'   => '',
				'taxonomy'    => '',
				'min_max_step'=> '',
				'class'       => '',
				'condition'   => 'breadcrumb:is(on)',
				'operator'    => 'and'
			),
			array(
				'id'          => 'breadcrumbs_color_divider',
				'label'       => __( 'Breadcrumb divider color', 'tilt' ),
				'desc'        => __( 'Click input field for color picker or enter your custom value. If left empty, general breadcrumbs color will be used.', 'tilt' ),
				'std'         => '',
				'type'        => 'colorpicker',
				'section'     => 'title_options',
				'rows'        => '',
				'post_type'   => '',
				'taxonomy'    => '',
				'min_max_step'=> '',
				'class'       => '',
				'condition'   => 'breadcrumb:is(on)',
				'operator'    => 'and'
			),
			array(
				'id'          => 'breadcrumbs_text_size',
				'label'       => __( 'Breadcrumbs font size', 'tilt' ),
				'desc'        => __( 'Set the size of the breadcrumbs font. <br /> Remember to add <code>px</code> value after the number.', 'tilt' ),
				'std'         => '16px',
				'type'        => 'text',
				'section'     => 'title_options',
				'rows'        => '',
				'post_type'   => '',
				'taxonomy'    => '',
				'min_max_step'=> '',
				'class'       => '',
				'condition'   => 'breadcrumb:is(on)',
				'operator'    => 'and'
			),
			array(
				'id'          => 'breadcrumbs_font',
				'label'       => __( 'Breadcrumbs font', 'tilt' ),
				'desc'        => '',
				'std'         => '',
				'type'        => 'typography',
				'section'     => 'title_options',
				'rows'        => '',
				'post_type'   => '',
				'taxonomy'    => '',
				'min_max_step'=> '',
				'class'       => '',
				'condition'   => 'breadcrumb:is(on)',
				'operator'    => 'and'
			),
			array(
				'id'          => 'breadcrumb_yoast',
				'label'       => __( 'Yoast SEO breadcrumbs', 'tilt' ),
				'desc'        => __( 'Use breadcrumbs provided by Yoast SEO plugin instead of default ones. Requires Yoast SEO plugin installed.', 'tilt' ),
				'std'         => 'off',
				'type'        => 'on-off',
				'section'     => 'title_options',
				'rows'        => '',
				'post_type'   => '',
				'taxonomy'    => '',
				'min_max_step'=> '',
				'class'       => '',
				'condition'   => '',
				'operator'    => 'and'
			),
			array(
				'id'          => 'global_color_section',
				'label'       => __( 'Global', 'tilt' ),
				'desc'        => '',
				'std'         => '',
				'type'        => 'tab',
				'section'     => 'color_typography',
				'rows'        => '',
				'post_type'   => '',
				'taxonomy'    => '',
				'min_max_step'=> '',
				'class'       => '',
				'condition'   => '',
				'operator'    => 'and'
			),
			array(
				'id'          => 'custom_fonts',
				'label'       => __( 'Add custom fonts', 'tilt' ),
				'desc'        => __( 'Upload your custom font files to <code>tilt/library/fonts</code> folder.', 'tilt' ),
				'std'         => '',
				'type'        => 'list-item',
				'section'     => 'color_typography',
				'settings'    => array(
					array(
						'id'          => 'custom_font_style',
						'label'       => __( 'Font CSS code', 'tilt' ),
						'desc'        => __( 'Paste your font\'s CSS code (<code>@font-face ...</code>)', 'tilt' ),
						'std'         => '',
						'type'        => 'textarea-simple',
						'rows'        => '',
						'post_type'   => '',
						'taxonomy'    => '',
						'min_max_step'=> '',
						'class'       => '',
						'condition'   => '',
						'operator'    => 'and'
					),
				)
			),
			array(
				'id'          => 'body_font',
				'label'       => __( 'Body font', 'tilt' ),
				'desc'        => '',
				'std'         => '',
				'type'        => 'typography',
				'section'     => 'color_typography',
				'rows'        => '',
				'post_type'   => '',
				'taxonomy'    => '',
				'min_max_step'=> '',
				'class'       => '',
				'condition'   => '',
				'operator'    => 'and'
			),
			array(
				'id'          => 'body_size',
				'label'       => __( 'Body font size', 'tilt' ),
				'desc'        => __( 'Remember to add <code>px</code> value after the number. For example: <code>13px</code>', 'tilt' ),
				'std'         => '14px',
				'type'        => 'text',
				'section'     => 'color_typography',
				'rows'        => '',
				'post_type'   => '',
				'taxonomy'    => '',
				'min_max_step'=> '',
				'class'       => '',
				'condition'   => '',
				'operator'    => 'and'
			),
			array(
				'id'          => 'body_text_color',
				'label'       => __( 'Body text color', 'tilt' ),
				'desc'        => __( 'General color for body content.', 'tilt' ),
				'std'         => '#777d8b',
				'type'        => 'colorpicker',
				'section'     => 'color_typography',
				'rows'        => '',
				'post_type'   => '',
				'taxonomy'    => '',
				'min_max_step'=> '',
				'class'       => '',
				'condition'   => '',
				'operator'    => 'and'
			),
			array(
				'id'          => 'link_color',
				'label'       => __( 'Link color', 'tilt' ),
				'desc'        => __( 'Global link color in the main content area.', 'tilt' ),
				'std'         => '',
				'type'        => 'colorpicker',
				'section'     => 'color_typography',
				'rows'        => '',
				'post_type'   => '',
				'taxonomy'    => '',
				'min_max_step'=> '',
				'class'       => '',
				'condition'   => '',
				'operator'    => 'and'
			),
			array(
				'id'          => 'link_hover_color',
				'label'       => __( 'Link hover color', 'tilt' ),
				'desc'        => __( 'Global link hover color in the main content area. <br /> To use "Theme accent color" leave empty.', 'tilt' ),
				'std'         => '',
				'type'        => 'colorpicker',
				'section'     => 'color_typography',
				'rows'        => '',
				'post_type'   => '',
				'taxonomy'    => '',
				'min_max_step'=> '',
				'class'       => '',
				'condition'   => '',
				'operator'    => 'and'
			),
			array(
				'id'      => 'font_subsets',
				'label'   => 'Google font subsets',
			    'desc'    => 'Add needed font subsets if available.',
			    'std'     => '',
			    'type'    => 'checkbox',
			    'section' => 'color_typography',
			    'choices' => array(
			        array(
			            'value' => 'latin',
			            'label' => 'Latin'
			        ),
			        array(
				        'value' => 'latin-ext',
				        'label' => 'Latin-ext'
			        ),
			        array(
				        'value' => 'cyrillic',
				        'label' => 'Cyrillic'
			        ),
			        array(
				        'value' => 'cyrillic-ext',
				        'label' => 'Cyrillic-ext'
			        ),
			        array(
				        'value' => 'greek',
				        'label' => 'Greek'
			        ),

			        array(
				        'value' => 'greek-ext',
				        'label' => 'Greek-ext'
			        ),
			        array(
			            'value' => 'vietnamese',
			            'label' => 'Vietnamese'
			        )
			    )
			),
			array(
				'id'          => 'headings_tab',
				'label'       => __( 'Headings', 'tilt' ),
				'desc'        => '',
				'std'         => '',
				'type'        => 'tab',
				'section'     => 'color_typography',
				'rows'        => '',
				'post_type'   => '',
				'taxonomy'    => '',
				'min_max_step'=> '',
				'class'       => '',
				'condition'   => '',
				'operator'    => 'and'
			),
			array(
				'id'          => 'headings_color',
				'label'       => __( 'Heading color (H1, H2, H3, H4, H5, H6)', 'tilt' ),
				'desc'        => __( 'Color for heading tags. The color is applied to all heading elements, if different color is not specified in element styling.', 'tilt' ),
				'std'         => '#36353c',
				'type'        => 'colorpicker',
				'section'     => 'color_typography',
				'rows'        => '',
				'post_type'   => '',
				'taxonomy'    => '',
				'min_max_step'=> '',
				'class'       => '',
				'condition'   => '',
				'operator'    => 'and'
			),
			array(
				'id'          => 'heading_font',
				'label'       => __( 'Default heading font', 'tilt' ),
				'desc'        => '',
				'std'         => '',
				'type'        => 'typography',
				'section'     => 'color_typography',
				'rows'        => '',
				'post_type'   => '',
				'taxonomy'    => '',
				'min_max_step'=> '',
				'class'       => '',
				'condition'   => '',
				'operator'    => 'and'
			),
			array(
				'id'          => 'vc_heading_font',
				'label'       => __( 'Visual Composer heading element title font', 'tilt' ),
				'desc'        => '',
				'std'         => '',
				'type'        => 'typography',
				'section'     => 'color_typography',
				'rows'        => '',
				'post_type'   => '',
				'taxonomy'    => '',
				'min_max_step'=> '',
				'class'       => '',
				'condition'   => '',
				'operator'    => 'and'
			),
			array(
				'id'          => 'vc_heading_font_sub',
				'label'       => __( 'Visual Composer heading element subtitle font', 'tilt' ),
				'desc'        => '',
				'std'         => '',
				'type'        => 'typography',
				'section'     => 'color_typography',
				'rows'        => '',
				'post_type'   => '',
				'taxonomy'    => '',
				'min_max_step'=> '',
				'class'       => '',
				'condition'   => '',
				'operator'    => 'and'
			),
			array(
				'id'          => 'h1',
				'label'       => __( 'H1', 'tilt' ),
				'desc'        => __( 'Heading 1 tag font size. <br /> Remember to add <code>px</code> value after the number.', 'tilt' ),
				'std'         => '52px',
				'type'        => 'text',
				'section'     => 'color_typography',
				'rows'        => '',
				'post_type'   => '',
				'taxonomy'    => '',
				'min_max_step'=> '',
				'class'       => '',
				'condition'   => '',
				'operator'    => 'and'
			),
			array(
				'id'          => 'h2',
				'label'       => __( 'H2', 'tilt' ),
				'desc'        => __( 'Heading 2 tag font size. <br />Remember to add <code>px</code> value after the number.', 'tilt' ),
				'std'         => '44px',
				'type'        => 'text',
				'section'     => 'color_typography',
				'rows'        => '',
				'post_type'   => '',
				'taxonomy'    => '',
				'min_max_step'=> '',
				'class'       => '',
				'condition'   => '',
				'operator'    => 'and'
			),
			array(
				'id'          => 'h3',
				'label'       => __( 'H3', 'tilt' ),
				'desc'        => __( 'Heading 3 tag font size. <br />Remember to add <code>px</code> value after the number.', 'tilt' ),
				'std'         => '36px',
				'type'        => 'text',
				'section'     => 'color_typography',
				'rows'        => '',
				'post_type'   => '',
				'taxonomy'    => '',
				'min_max_step'=> '',
				'class'       => '',
				'condition'   => '',
				'operator'    => 'and'
			),
			array(
				'id'          => 'h4',
				'label'       => __( 'H4', 'tilt' ),
				'desc'        => __( 'Heading 4 tag font size. <br />Remember to add <code>px</code> value after the number.', 'tilt' ),
				'std'         => '28px',
				'type'        => 'text',
				'section'     => 'color_typography',
				'rows'        => '',
				'post_type'   => '',
				'taxonomy'    => '',
				'min_max_step'=> '',
				'class'       => '',
				'condition'   => '',
				'operator'    => 'and'
			),
			array(
				'id'          => 'h5',
				'label'       => __( 'H5', 'tilt' ),
				'desc'        => __( 'Heading 5 tag font size. <br />Remember to add <code>px</code> value after the number.', 'tilt' ),
				'std'         => '20px',
				'type'        => 'text',
				'section'     => 'color_typography',
				'rows'        => '',
				'post_type'   => '',
				'taxonomy'    => '',
				'min_max_step'=> '',
				'class'       => '',
				'condition'   => '',
				'operator'    => 'and'
			),
			array(
				'id'          => 'h6',
				'label'       => __( 'H6', 'tilt' ),
				'desc'        => __( 'Heading 6 tag font size. <br />Remember to add <code>px</code> value after the number.', 'tilt' ),
				'std'         => '14px',
				'type'        => 'text',
				'section'     => 'color_typography',
				'rows'        => '',
				'post_type'   => '',
				'taxonomy'    => '',
				'min_max_step'=> '',
				'class'       => '',
				'condition'   => '',
				'operator'    => 'and'
			),
			array(
				'id'          => 'Blog_posts_tab',
				'label'       => __( 'Blog &amp; Posts', 'tilt' ),
				'desc'        => '',
				'std'         => '',
				'type'        => 'tab',
				'section'     => 'color_typography',
				'rows'        => '',
				'post_type'   => '',
				'taxonomy'    => '',
				'min_max_step'=> '',
				'class'       => '',
				'condition'   => '',
				'operator'    => 'and'
			),
			array(
				'id'          => 'post_heading_color',
				'label'       => __( 'Post heading text color', 'tilt' ),
				'desc'        => __( 'Set color for blog headings on blog index and single post pages.', 'tilt' ),
				'std'         => '#36353c',
				'type'        => 'colorpicker',
				'section'     => 'color_typography',
				'rows'        => '',
				'post_type'   => '',
				'taxonomy'    => '',
				'min_max_step'=> '',
				'class'       => '',
				'condition'   => '',
				'operator'    => 'and'
			),
			array(
				'id'          => 'post_heading_font',
				'label'       => __( 'Post heading font', 'tilt' ),
				'desc'        => '',
				'std'         => '',
				'type'        => 'typography',
				'section'     => 'color_typography',
				'rows'        => '',
				'post_type'   => '',
				'taxonomy'    => '',
				'min_max_step'=> '',
				'class'       => '',
				'condition'   => '',
				'operator'    => 'and'
			),
			array(
				'id'          => 'post_color',
				'label'       => __( 'Post content text color', 'tilt' ),
				'desc'        => __( 'Set color for blog content on blog index and single post pages.', 'tilt' ),
				'std'         => '#777d8b',
				'type'        => 'colorpicker',
				'section'     => 'color_typography',
				'rows'        => '',
				'post_type'   => '',
				'taxonomy'    => '',
				'min_max_step'=> '',
				'class'       => '',
				'condition'   => '',
				'operator'    => 'and'
			),
			array(
				'id'          => 'post_content_font',
				'label'       => __( 'Post content font', 'tilt' ),
				'desc'        => '',
				'std'         => '',
				'type'        => 'typography',
				'section'     => 'color_typography',
				'rows'        => '',
				'post_type'   => '',
				'taxonomy'    => '',
				'min_max_step'=> '',
				'class'       => '',
				'condition'   => '',
				'operator'    => 'and'
			),
			array(
				'id'          => 'meta_color',
				'label'       => __( 'Post meta text color', 'tilt' ),
				'desc'        => __( 'Set color for post meta fields (tags, date, category, author, comments count) on blog index and single post pages.', 'tilt' ),
				'std'         => '',
				'type'        => 'colorpicker',
				'section'     => 'color_typography',
				'rows'        => '',
				'post_type'   => '',
				'taxonomy'    => '',
				'min_max_step'=> '',
				'class'       => '',
				'condition'   => '',
				'operator'    => 'and'
			),
			array(
				'id'          => 'sidebar_tab',
				'label'       => __( 'Sidebar', 'tilt' ),
				'desc'        => '',
				'std'         => '',
				'type'        => 'tab',
				'section'     => 'color_typography',
				'rows'        => '',
				'post_type'   => '',
				'taxonomy'    => '',
				'min_max_step'=> '',
				'class'       => '',
				'condition'   => '',
				'operator'    => 'and'
			),
			array(
				'id'          => 'widget_font',
				'label'       => __( 'Widget title font', 'tilt' ),
				'desc'        => '',
				'std'         => '',
				'type'        => 'typography',
				'section'     => 'color_typography',
				'rows'        => '',
				'post_type'   => '',
				'taxonomy'    => '',
				'min_max_step'=> '',
				'class'       => '',
				'condition'   => '',
				'operator'    => 'and'
			),
			array(
				'id'          => 'sidebar_title_color',
				'label'       => __( 'Widget title color', 'tilt' ),
				'desc'        => __( 'Color for widget titles in sidebar.', 'tilt' ),
				'std'         => '',
				'type'        => 'colorpicker',
				'section'     => 'color_typography',
				'rows'        => '',
				'post_type'   => '',
				'taxonomy'    => '',
				'min_max_step'=> '',
				'class'       => '',
				'condition'   => '',
				'operator'    => 'and'
			),

			array(
				'id'          => 'sidebar_text_color',
				'label'       => __( 'Text color', 'tilt' ),
				'desc'        => __( 'Choose text color for sidebar widget content.', 'tilt' ),
				'std'         => '',
				'type'        => 'colorpicker',
				'section'     => 'color_typography',
				'rows'        => '',
				'post_type'   => '',
				'taxonomy'    => '',
				'min_max_step'=> '',
				'class'       => '',
				'condition'   => '',
				'operator'    => 'and'
			),
			array(
				'id'          => 'sidebar_link_color',
				'label'       => __( 'Link color', 'tilt' ),
				'desc'        => __( 'Choose color for links in sidebar.', 'tilt' ),
				'std'         => '',
				'type'        => 'colorpicker',
				'section'     => 'color_typography',
				'rows'        => '',
				'post_type'   => '',
				'taxonomy'    => '',
				'min_max_step'=> '',
				'class'       => '',
				'condition'   => '',
				'operator'    => 'and'
			),
			array(
				'id'          => 'sidebar_link_hover_color',
				'label'       => __( 'Link hover color', 'tilt' ),
				'desc'        => __( 'Leave empty to use "Theme accent color".', 'tilt' ),
				'std'         => '',
				'type'        => 'colorpicker',
				'section'     => 'color_typography',
				'rows'        => '',
				'post_type'   => '',
				'taxonomy'    => '',
				'min_max_step'=> '',
				'class'       => '',
				'condition'   => '',
				'operator'    => 'and'
			),
			array(
				'id'          => 'sidebar_divider_color',
				'label'       => __( 'Widget divider color', 'tilt' ),
				'desc'        => __( 'Choose border line color separating list items in sidebar.', 'tilt' ),
				'std'         => '',
				'type'        => 'colorpicker',
				'section'     => 'color_typography',
				'rows'        => '',
				'post_type'   => '',
				'taxonomy'    => '',
				'min_max_step'=> '',
				'class'       => '',
				'condition'   => '',
				'operator'    => 'and'
			),
			array(
				'id'          => 'footer_tab',
				'label'       => __( 'Footer', 'tilt' ),
				'desc'        => '',
				'std'         => '',
				'type'        => 'tab',
				'section'     => 'color_typography',
				'rows'        => '',
				'post_type'   => '',
				'taxonomy'    => '',
				'min_max_step'=> '',
				'class'       => '',
				'condition'   => '',
				'operator'    => 'and'
			),
			array(
				'id'          => 'footer_text_color',
				'label'       => __( 'Text color', 'tilt' ),
				'desc'        => __( 'Choose text color for your footer widget content.', 'tilt' ),
				'std'         => '',
				'type'        => 'colorpicker',
				'section'     => 'color_typography',
				'rows'        => '',
				'post_type'   => '',
				'taxonomy'    => '',
				'min_max_step'=> '',
				'class'       => '',
				'condition'   => '',
				'operator'    => 'and'
			),
			array(
				'id'          => 'footer_link',
				'label'       => __( 'Link color', 'tilt' ),
				'desc'        => __( 'Choose the color of links in footer widgets.', 'tilt' ),
				'std'         => '',
				'type'        => 'colorpicker',
				'section'     => 'color_typography',
				'rows'        => '',
				'post_type'   => '',
				'taxonomy'    => '',
				'min_max_step'=> '',
				'class'       => '',
				'condition'   => '',
				'operator'    => 'and'
			),
			array(
				'id'          => 'footer_link_hover',
				'label'       => __( 'Link hover color', 'tilt' ),
				'desc'        => __( 'Choose the hover color of links in footer widgets. Leave empty to use "Theme accent color".', 'tilt' ),
				'std'         => '',
				'type'        => 'colorpicker',
				'section'     => 'color_typography',
				'rows'        => '',
				'post_type'   => '',
				'taxonomy'    => '',
				'min_max_step'=> '',
				'class'       => '',
				'condition'   => '',
				'operator'    => 'and'
			),
			array(
				'id'          => 'footer_widget_title',
				'label'       => __( 'Widget title color', 'tilt' ),
				'desc'        => __( 'Choose the color of widget titles in the footer.', 'tilt' ),
				'std'         => '',
				'type'        => 'colorpicker',
				'section'     => 'color_typography',
				'rows'        => '',
				'post_type'   => '',
				'taxonomy'    => '',
				'min_max_step'=> '',
				'class'       => '',
				'condition'   => '',
				'operator'    => 'and'
			),
			array(
				'id'          => 'copyright_tab',
				'label'       => __( 'Copyright', 'tilt' ),
				'desc'        => '',
				'std'         => '',
				'type'        => 'tab',
				'section'     => 'color_typography',
				'rows'        => '',
				'post_type'   => '',
				'taxonomy'    => '',
				'min_max_step'=> '',
				'class'       => '',
				'condition'   => '',
				'operator'    => 'and'
			),
			array(
				'id'          => 'copyright_text_color',
				'label'       => __( 'Text color', 'tilt' ),
				'desc'        => __( 'Choose text color for your copyright area widget content.', 'tilt' ),
				'std'         => '',
				'type'        => 'colorpicker',
				'section'     => 'color_typography',
				'rows'        => '',
				'post_type'   => '',
				'taxonomy'    => '',
				'min_max_step'=> '',
				'class'       => '',
				'condition'   => '',
				'operator'    => 'and'
			),
			array(
				'id'          => 'copyright_link',
				'label'       => __( 'Link color', 'tilt' ),
				'desc'        => __( 'Color for links located in your copyright area widgets.', 'tilt' ),
				'std'         => '',
				'type'        => 'colorpicker',
				'section'     => 'color_typography',
				'rows'        => '',
				'post_type'   => '',
				'taxonomy'    => '',
				'min_max_step'=> '',
				'class'       => '',
				'condition'   => '',
				'operator'    => 'and'
			),
			array(
				'id'          => 'copyright_link_hover',
				'label'       => __( 'Link hover color', 'tilt' ),
				'desc'        => __( 'Leave empty to use "Theme accent color".', 'tilt' ),
				'std'         => '',
				'type'        => 'colorpicker',
				'section'     => 'color_typography',
				'rows'        => '',
				'post_type'   => '',
				'taxonomy'    => '',
				'min_max_step'=> '',
				'class'       => '',
				'condition'   => '',
				'operator'    => 'and'
			),
			array(
				'id'          => 'copyright_widget_title',
				'label'       => __( 'Widget title color', 'tilt' ),
				'desc'        => __( 'Color for widget titles in copyright area.', 'tilt' ),
				'std'         => '',
				'type'        => 'colorpicker',
				'section'     => 'color_typography',
				'rows'        => '',
				'post_type'   => '',
				'taxonomy'    => '',
				'min_max_step'=> '',
				'class'       => '',
				'condition'   => '',
				'operator'    => 'and'
			),
			array(
				'id'          => 'custom_css',
				'label'       => __( 'Custom CSS', 'tilt' ),
				'desc'        => __( 'Add any of your custom CSS here: <br />

<pre><code>.page-id-10 #site-header {
background:none;
}
</code></pre>

Have fun!', 'tilt' ),
				'std'         => '',
				'type'        => 'textarea-simple',
				'section'     => 'custom_css',
				'rows'        => '',
				'post_type'   => '',
				'taxonomy'    => '',
				'min_max_step'=> '',
				'class'       => '',
				'condition'   => '',
				'operator'    => 'and'
			),
			array(
				'id'          => 'import_demo_data_section',
				'label'       => __( 'Import demo', 'tilt' ),
				'desc'        => __( '	<h1 class="import_heading">Welcome to Tilt</h1>
										<a class="import_img" href="http://www.whitecollars.co/tilt" target="_blank"><img src="http://www.whitecollars.co/themeforest/tilt/demo_data/demo_import_img.png"></a>
										<span class="import_note">
											You can import all the demo data to replicate the live preview website.<br />
											This will automatically import and set <strong>posts</strong>, <strong>pages</strong>, <strong>widgets</strong>, <strong>menus</strong> and <strong>reading settings</strong>. <br />
											No worries, you can change and edit everything later.
										</span>
										<a class="import_button" href="themes.php?page=ot-theme-options&amp;import_data_content=true">Import demo data</a>
										<span class="import_note import_warning"><div class="important_tag">IMPORTANT</div>Images and graphics used in live demo are licensed for preview purposes only and are replaced with placeholder images in this demo content.</span>', 'tilt' ),
				'std'         => '',
				'type'        => 'textblock',
				'section'     => 'import_data',
				'rows'        => '',
				'post_type'   => '',
				'taxonomy'    => '',
				'min_max_step'=> '',
				'class'       => 'import-demo',
				'condition'   => '',
				'operator'    => 'and'
			),
			array(
				'id'          => 'import_successful_section',
				'label'       => __( 'Import successful', 'tilt' ),
				'desc'        => __(    '<i class="fa fa-child"></i>
										<h1>Data Imported Successfully</h1>
										<h5>Go on, start using tilt!</h5>', 'tilt' ),
				'std'         => '',
				'type'        => 'textblock',
				'section'     => 'import_successful',
				'rows'        => '',
				'post_type'   => '',
				'taxonomy'    => '',
				'min_max_step'=> '',
				'class'       => 'import-successful',
				'condition'   => '',
				'operator'    => 'and'
			)
		)
	);

	/* allow settings to be filtered before saving */
	$custom_settings = apply_filters( ot_settings_id() . '_args', $custom_settings );

	/* settings are not the same update the DB */
	if ( $saved_settings !== $custom_settings ) {
		update_option( ot_settings_id(), $custom_settings );
	}

	/* Lets OptionTree know the UI Builder is being overridden */
	global $ot_has_custom_theme_options;
	$ot_has_custom_theme_options = true;

}