﻿
/* Adiciona funcionalidades para cálculo de cubagem */
jQuery(function(){
    $('table.CalculoCubagem').each(function(idx, tbl) {
        cubagem.init(tbl, false);
        $(tbl).find('a.AdicionarLinha').click(function() { cubagem.adicionar(tbl); });
        $(tbl).find('a.Limpar').click(function() { cubagem.limpar(tbl); });
    });
});

var cubagem = {
    /* Private */
    _template : '', 
    _showLog : false,
    _reSequence : function(t) {
        this._log(t, '_reSequence()');
        $(t).find('tbody td.Sequencia span').each(function(idx, span) {
            var count = idx + 1;
            if (('' + count).length == 1)
                count = '0' + count;
            span.innerHTML = count;
        });
    },
    _attachEvents : function(t) {
        this._log(t, '_attachEvents()');
        $(t).find('tbody tr').each(function(idx, tr) {
            $(tr).find('input').each(function(idxx, input){
                $(input).keyup(function(e) {
                    var isQtd = $(this).hasClass('Quantidade');
                    var reg = isQtd ? /[^0-9]/g : /[^0-9,]/g;
                    if ((e.which>=48 && e.which<=57) || (e.which>=96 && e.which<=105) || e.which==8 || e.which==46 || (!isQtd && e.which==188))
	                    cubagem.calcular(t);
                    else if (this.value.match(reg))
                        this.value = this.value.replace(reg,'');
                });
                $(input).blur(function(e) {
                    var isQtd = $(this).hasClass('Quantidade');
                    var v = this.value;
                    var isNum = !isNaN(parseFloat(v.replace(',','.')));
                    if ((v != '') && ((!isNum) || (v.match(',') && v.replace(',','.') < 0.1))) {
                        this.value = (!isNum ? (isQtd ? '0' : '0,00') : '0,10');
                        cubagem.calcular(t);
                    }
                });
                $(input).bind('paste', function(e){ 
                    return false;
                });
            });
            $(tr).find('a.Remover').click(function() {
                cubagem.remover(t, tr);
            });
            if (idx > 0) {
                $(tr).find('a.Remover').css({ display: 'inline' });
            }
        });    
    },
    _focus : function(t) {
        this._log(t, '_focus()');
        $(t).find('input.Quantidade:first-item').focus();
    },
    _log : function(t, m) {
        if (this._showLog) {
            var td = $(t).find('tr.Log td')[0];
            td.innerHTML += m + '\n';
        }
    },
        
    /* Public */
    init : function(t, l) {
        this._log(t, 'init()');
        if (this._template == '')
            this._template = $(t).find('tbody tr:first-child').html();

        if (l) {
            $(t).find('tr.Log').css({ display: 'block' });
            this._showLog = true;
        }
        this.limpar(t);
    },
    calcular : function(t) {
        this._log(t, 'calcular()');
        var totalCube = 0;
        var totalWeight = 0;
        $(t).find('tbody tr').each(function(idx, tr) {
            var q = $(tr).find('input.Quantidade')[0].value.replace(',','.');
            var a = $(tr).find('input.Altura')[0].value.replace(',','.');
            var l = $(tr).find('input.Largura')[0].value.replace(',','.');
            var p = $(tr).find('input.Profundidade')[0].value.replace(',','.');
            
            var cube = q * a * l * p;
            var wheight = cube * 300;
            
            $(tr).find('span.Cubagem')[0].innerHTML = !isNaN(cube) ? cube.toFixed(2).replace('.',',') : '0,00';
            $(tr).find('span.Peso')[0].innerHTML = !isNaN(wheight) ? wheight.toFixed(2).replace('.',',') : '0,00';

            totalCube += cube;
            totalWeight += wheight;
        });
        
        $(t).find('tfoot span.TotalCubagem')[0].innerHTML = !isNaN(totalCube) ? totalCube.toFixed(2).replace('.',',') : '0,00';
        $(t).find('tfoot span.TotalPeso')[0].innerHTML = !isNaN(totalWeight) ? totalWeight.toFixed(2).replace('.',',') : '0,00';
    },
    limpar : function(t) {
        this._log(t, 'limpar()');
        $(t).find('tbody tr').each(function(idx, tr) {
            $(tr).remove();
        });
        this.adicionar(t);
        this.calcular(t);
        this._focus(t);
    },
    adicionar : function(t) {
        this._log(t, 'adicionar()');
        $(t).find('tbody').append('<tr>' + this._template + '</tr>');
        this._reSequence(t);
        this._attachEvents(t);
        this._focus(t);
    },
    remover : function(t, l) {
        this._log(t, 'remover()');
        $(l).remove();
        this._reSequence(t);
        this.calcular(t);
        this._focus(t);
    }
}